local t = Def.ActorFrame {};
local song = GAMESTATE:GetCurrentSong();
local sname = song:GetDisplayMainTitle();
local ssname = song:GetDisplaySubTitle();
if ssname == "" then ssname = nil end
local sartist = song:GetDisplayArtist();
local jkt = song:GetJacketPath();
local bn = song:GetBannerPath();
local cx = SCREEN_CENTER_X;
local cy = SCREEN_CENTER_Y;
t[#t+1] = Def.ActorFrame {
	LoadActor("_riftback")..{
		InitCommand=function(self) self:Center() end;
	};
	LoadActor("_riftportal")..{
		InitCommand=function(self) self:Center():zoom(0.7):diffusealpha(0.6) end;
		OnCommand=function(self) self:accelerate(4.4):addrotationz(2880):zoom(1.2):diffusealpha(1) end;
	};
};
t[#t+1] = LoadActor("_omessound")..{
	OnCommand=function(self) self:queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};
if song:HasJacket() then
	t[#t+1] = LoadActor(jkt)..{
		InitCommand=function(self) self:Center():addy(-25):diffusealpha(0):scaletofit(cx-100,cy-125,cx+100,cy+75) end;
		OnCommand=function(self) self:sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
		Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
	};
elseif song:HasBanner() then
	t[#t+1] = LoadActor(bn)..{
		InitCommand=function(self) self:Center():addy(-25):diffusealpha(0):scaletofit(cx-150,cy-175,cx+150,cy+125) end;
		OnCommand=function(self) self:sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
		Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
	};
else
	t[#t+1] = LoadActor(THEME:GetPathG("", "Common fallback jacket"))..{
		InitCommand=function(self) self:Center():addy(-25):diffusealpha(0):zoom(0.4) end;
		OnCommand=function(self) self:sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
		Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
	};
end
t[#t+1] = LoadActor(THEME:GetPathG("ScreenStageInformation", "Stage extra2"))..{
	InitCommand=function(self) self:Center():addy(175):diffusealpha(0):zoom(0.6) end;
	OnCommand=function(self) self:sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
	Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
	Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
	Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
	Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
	Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
	Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
	Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
};
t[#t+1] = LoadFont("_pixellari 32px")..{ -- song title
	InitCommand=function(self) self:Center():addy(110):diffusealpha(0) end;
	OnCommand=function(self)
		if ssname then -- main and sub title
			self:settextf("%s\n\n%s",sname,ssname)
			self:zoom(0.7)
		elseif ssname == "" or ssname == nil then -- just main title
			self:settextf("%s",sname)
			self:addy(-5)
			self:zoom(1)
		end
		self:sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
	Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
	Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
	Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
	Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
	Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
	Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
	Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
};
t[#t+1] = LoadFont("_pixellari 32px")..{ -- song artist
	InitCommand=function(self) self:Center():addy(125):diffusealpha(0) end;
	OnCommand=function(self)
		if ssname then --has sub title
			self:addy(20):zoom(0.9)
		elseif ssname == "" or ssname == nil then --no sub title
			self:addy(10):zoom(1)
		end
		self:settext(sartist):sleep(1):linear(0.75):diffusealpha(1):sleep(0.2):queuecommand("Vibe1") end;
	Vibe1Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe2") end;
	Vibe2Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe3") end;
	Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
	Vibe4Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.3):queuecommand("Vibe5") end;
	Vibe5Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.3):queuecommand("Vibe6") end;
	Vibe6Command=function(self) self:vibrate():effectmagnitude(18,18,18):sleep(0.3):queuecommand("Vibe7") end;
	Vibe7Command=function(self) self:vibrate():effectmagnitude(21,21,21) end;
};
t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#000000")):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(2):linear(3.3):diffuse(color("#990099")):diffusealpha(1) end;
};
t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#000000")):diffusealpha(0):draworder(10) end;
	OnCommand=function(self) self:sleep(4.4):diffusealpha(1) end;
};


return t